//=============================================================================
// Balloon subclass for metal balloons, never spawned (on purpose lol!!)
//=============================================================================
class Balloon_metal extends Balloon;

/* metal balloons group contains the following balloons:
	- red 		(layers: 10, speed: 1.300000, key: G)
	- blue		(layers: 15, speed: 1.400000, key: H)
	- green		(layers: 20, speed: 1.500000, key: I)
	- Yellow	(layers: 25, speed: 1.600000, key: J)
*/

#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=MetalBalloon anivfile=Models\MetalBalloon_a.3d datafile=Models\MetalBalloon_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=MetalBalloon x=0 y=0 z=0
#exec mesh sequence mesh=MetalBalloon seq=All startframe=0 numframes=1
#exec meshmap new meshmap=MetalBalloon mesh=MetalBalloon
#exec meshmap scale meshmap=MetalBalloon x=0.12085 y=0.12085 z=0.24170

function SetColor()
{
	if ( Health <= 10 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cMetalRed';
		AirSpeed = BaseSpeed * 1.300000;
		DrawScale = Default.DrawScale * 0.9 * 0.9 * 0.9;
		}
	else if ( Health <= 15 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cMetalBlue';
		AirSpeed = BaseSpeed * 1.400000;
		DrawScale = Default.DrawScale * 0.9 * 0.9;
		}
	else if ( Health <= 20 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cMetalGreen';
		AirSpeed = BaseSpeed * 1.500000;
		DrawScale = Default.DrawScale * 0.9;
		}
	else
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cMetalYellow';
		AirSpeed = BaseSpeed * 1.600000;
		}
}

defaultproperties
{
	 layers=1
	 speed=1.000000
     AmbientGlow=64
	 DrawType=DT_Mesh
	 Mesh=Mesh'MetalBalloon'
	 CollisionRadius=16.00000
	 CollisionHeight=30.93823
	 DrawScale=0.5
}
